<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

use App\Http\Services\DBClientConnection;

class InstrumentosAudRiasAPNController extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    public function obtenerInstrumentosActivos(Request $request) {
        return DB::connection($this->cliente)->select("
            select irp_pk_id, irp_version, irp_comentarios, irp_instrumento
            from instrumentos_rias_apn_atn_preconcepcional
            where irp_activa = true

            union all

            select iri_pk_id, iri_version, iri_comentarios, iri_instrumento
            from instrumentos_rias_apn_ive
            where iri_activa = true

            union all

            select irp_pk_id, irp_version, irp_comentarios, irp_instrumento
            from instrumentos_rias_apn_cuidado_prenatal
            where irp_activa = true

            union all

            select irc_pk_id, irc_version, irc_comentarios, irc_instrumento
            from instrumentos_rias_apn_curso_preparacion
            where irc_activa = true

            union all

            select ira_pk_id, ira_version, ira_comentarios, ira_instrumento
            from instrumentos_rias_apn_atencion_parto
            where ira_activa = true

            union all

            select ire_pk_id, ire_version, ire_comentarios, ire_instrumento
            from instrumentos_rias_apn_emer_obstetrica
            where ire_activa = true

            union all

            select irp_pk_id, irp_version, irp_comentarios, irp_instrumento
            from instrumentos_rias_apn_atn_puerperio
            where irp_activa = true

            union all

            select irn_pk_id, irn_version, irn_comentarios, irn_instrumento
            from instrumentos_rias_apn_atencion_rn
            where irn_activa = true

            union all

            select irc_pk_id, irc_version, irc_comentarios, irc_instrumento
            from instrumentos_rias_apn_atn_complicaciones
            where irc_activa = true

            union all

            select irn_pk_id, irn_version, irn_comentarios, irn_instrumento
            from instrumentos_rias_apn_seguimiento_rn
            where irn_activa = true

            union all

            select irf_pk_id, irf_version, irf_comentarios, irf_instrumento
            from instrumentos_rias_apn_atn_familias
            where irf_activa = true
        ");
    }
}
