<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

use App\Http\Services\DBClientConnection;

use App\Models\clientes\PamecInstitucional;

class PamecInstitucionalController extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    /*public function obtenerVersionPamecInstitucional(Request $request, $anoTrabajo) {
        return PamecInstitucional::where('pai_ano', $anoTrabajo)->get()->toArray();
    }

    public function obtenerPamecInstitucionalPorId(Request $request, $id) {
        return PamecInstitucional::where('pai_pk_id', $id)->get()->toArray();
    }

    public function cargarPamec(Request $request, $Id, $indice) {
    // Validación del archivo enviado desde el frontend
    $request->validate([
      'archivo' => 'required|mimes:pdf,docx,xlsx|max:100000',
    ]);

    try {

      $archivoSubido = $request->file('archivo');
      //$nombreArchivo = $archivoSubido->getClientOriginalName();
      $extension = $archivoSubido->getClientOriginalExtension();

        $nombreArchivoSinExtension = 'PAMEC_'.$Id.'_'.$indice;
        $nombreArchivoFinal = $nombreArchivoSinExtension . '.' . $extension;
        $rutaArchivo = Storage::disk('pamec')->putFileAs('', $archivoSubido, $nombreArchivoFinal);
        $comentario = $request->input('comentario');

      // Crear una nueva entrada en la tabla archivos para almacenar la información relevante
      $archivo = PamecInstitucional::create([
        'ano_trabajo' => $Id,
        'nombre_docpamec' => $nombreArchivoFinal,
        'comentario' => $comentario,
        'ruta_docpamec' => $rutaArchivo,
        'mime_type' => $archivoSubido->getClientMimeType(),
      ]);

      return response()->json(['message' => 'Documento cargado con éxito', 'archivo'], 200);
    } catch (\Exception $e) {
      // Error en la carga del archivo
      return response()->json(['message' => $e->message, 'error'], 500);
    }

  }

  public function descargarPamec($id)
  {
    $archivo = PamecInstitucional::findOrFail($id);
    return Storage::disk('pamec')->download($archivo->ruta_docpamec, $archivo->nombre_docpamec);
  }*/

  /*public function eliminarArchivo($Id)
  {
    Anexos::where($Id, 'anexo_pk_id')->delete();
  }*/

  /*public function eliminarPamec($id)
  {
    $archivo = PamecInstitucional::findOrFail($id);

    // Eliminar el archivo físico de la carpeta "archivos"
    Storage::disk('pamec')->delete($archivo->ruta_docpamec);

    // Eliminar la entrada del archivo de la tabla "archivos"
    $archivo->delete();

    return response()->json(['message' => 'Archivo eliminado correctamente']);
  }*/
}
