<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\base\RepsPrestadores;
use App\Models\base\RepsPrestadoresSedes;
use App\Models\base\RepsServicios;

class RepsController extends Controller
{
    public function obtenerPrestadoresDepartamento(Request $request, $depto) {
        return RepsPrestadores::join('municipios', 'mun_pk_id', 'mun_fk_id')
                              ->where('reps_prestadores.dep_fk_id', $depto)
                              ->orderBy('rpr_razon_social')
                              ->get()->toArray();
    }

    public function obtenerPrestadoresMunicipio(Request $request, $municipio) {
        return RepsPrestadores::where('mun_fk_id', $municipio)
                              ->orderBy('rpr_razon_social')
                              ->get()->toArray();
    }

    public function obtenerSedesPrestador(Request $request, $idPrestador) {
        return RepsPrestadoresSedes::where('rpr_fk_id', $idPrestador)
                                   ->join('municipios', 'mun_pk_id', 'mun_fk_id')
                                   ->orderBy('rps_nombre_sede')
                                   ->get()->toArray();
    }

    public function obtenerSedesPrestadorMunicipio(Request $request, $idPrestador, $depto, $municipio) {
        return RepsPrestadoresSedes::where('rpr_fk_id', $idPrestador)
                                   ->join('municipios', 'mun_pk_id', 'mun_fk_id')
                                   ->where('dep_fk_id', $depto)
                                   ->where('mun_fk_id', $municipio)
                                   ->orderBy('rps_nombre_sede')
                                   ->get()->toArray();
    }

    public function obtenerServiciosSedeSuh3100(Request $request, $prestador, $sede) {
        return RepsServicios::selectRaw('null as svs_pk_id, grs_fk_id, grs_descripcion, rsr_codigo_servicio as svs_codigo_servicio, rsr_nombre_servicio as svs_nombre_servicio,
                                        rsr_3100_mod_intramural as svs_3100_mod_intramural, rsr_3100_mod_extramural as svs_3100_mod_extramural,
                                        rsr_3100_mod_unidad_movil as svs_3100_mod_unidad_movil, rsr_3100_mod_domiciliario as svs_3100_mod_domiciliario,
                                        rsr_3100_mod_jornada_salud as svs_3100_mod_jornada_salud, rsr_3100_mod_telemedicina as svs_3100_mod_telemedicina,
                                        rsr_3100_mod_prestador_referencia as svs_3100_mod_prestador_referencia, rsr_3100_mod_prf_tme_interactiva as svs_3100_mod_prf_tme_interactiva,
                                        rsr_3100_mod_prf_tme_no_interactiva as svs_3100_mod_prf_tme_no_interactiva, rsr_3100_mod_prf_tele_experticia as svs_3100_mod_prf_tele_experticia,
                                        rsr_3100_mod_prf_tele_monitoreo as svs_3100_mod_prf_tele_monitoreo, rsr_3100_mod_prestador_remisor as svs_3100_mod_prestador_remisor,
                                        rsr_3100_mod_pre_tele_experticia as svs_3100_mod_pre_tele_experticia, rsr_3100_mod_pre_tele_monitoreo as svs_3100_mod_pre_tele_monitoreo,
                                        rsr_3100_complejidad_baja as svs_3100_complejidad_baja, rsr_3100_complejidad_mediana as svs_3100_complejidad_mediana,
                                        rsr_3100_complejidad_alta as svs_3100_complejidad_alta, rsr_3100_sin_complejidad as svs_3100_sin_complejidad,
                                        rsr_3100_esp_oncologico as svs_3100_esp_oncologico, rsr_3100_esp_trasplante_osteomuscular as svs_3100_esp_trasplante_osteomuscular,
                                        rsr_3100_esp_trasplante_piel as svs_3100_esp_trasplante_piel, rsr_3100_esp_trasplante_cardiovascular as svs_3100_esp_trasplante_cardiovascular,
                                        rsr_3100_esp_trasplante_tejido_ocular as svs_3100_esp_trasplante_tejido_ocular, rsr_3100_esp_atencion_paciente_quemado as svs_3100_esp_atencion_paciente_quemado,
                                        rsr_3100_esp_spa as svs_3100_esp_spa, rsr_3100_esp_otras_patologias as svs_3100_esp_otras_patologias,
                                        rsr_3100_esp_tras_celulas_prog_hematopoyeticas as svs_3100_esp_tras_celulas_prog_hematopoyeticas,
                                        rsr_3100_esp_proc_quirurgicos_ambulatorios as svs_3100_esp_proc_quirurgicos_ambulatorios, rsr_3100_esp_organo_rinon as svs_3100_esp_organo_rinon,
                                        rsr_3100_esp_organo_higado as svs_3100_esp_organo_higado, rsr_3100_esp_organo_pancreas as svs_3100_esp_organo_pancreas,
                                        rsr_3100_esp_organo_intestino as svs_3100_esp_organo_intestino, rsr_3100_esp_organo_multivisceral as svs_3100_esp_organo_multivisceral,
                                        rsr_3100_esp_organo_corazon as svs_3100_esp_organo_corazon, rsr_3100_esp_organo_pulmon as svs_3100_esp_organo_pulmon,
                                        rsr_3100_esp_sustancias_psicoactivas as svs_3100_esp_sustancias_psicoactivas, rsr_3100_esp_trasplante_renal as svs_3100_esp_trasplante_renal,
                                        false as svs_creado_manualmente')
                            ->join('base.grupos_servicio', 'grs_pk_id', 'grs_fk_id')
                            ->where('rpr_fk_id', $prestador)
                            ->where('rps_fk_id', $sede)
                            ->orderBy('grs_descripcion')
                            ->orderBy('rsr_nombre_servicio')
                            ->get()->toArray();
    }

    public function obtenerServiciosPrestadorSuh3100(Request $request, $prestador) {
        return RepsServicios::selectRaw('distinct rsr_codigo_servicio as svs_codigo_servicio, rsr_nombre_servicio as svs_nombre_servicio, grs_descripcion')
                            ->join('base.grupos_servicio', 'grs_pk_id', 'grs_fk_id')
                            ->where('rpr_fk_id', $prestador)
                            ->orderBy('grs_descripcion')
                            ->orderBy('rsr_nombre_servicio')
                            ->get()->toArray();
    }

    public function obtenerServiciosSuh3100(Request $request) {
        return RepsServicios::selectRaw('distinct rsr_codigo_servicio as svs_codigo_servicio, rsr_nombre_servicio as svs_nombre_servicio, grs_descripcion')
                            ->join('base.grupos_servicio', 'grs_pk_id', 'grs_fk_id')
                            ->orderBy('grs_descripcion')
                            ->orderBy('rsr_nombre_servicio')
                            ->get()->toArray();
    }
}
