<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

use App\Http\Services\DBClientConnection;

use App\Models\clientes\InstrumentosRiasPyMVejezMujeres;
use App\Models\clientes\HistoricoInsRiasPyMVejezMujeres;

class InstrumentosRiasPyMVejezMujeresController extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    public function obtenerInstrumentos(Request $request) {
        return InstrumentosRiasPyMVejezMujeres::on($this->cliente)
                                            ->orderBy('irv_activa', 'desc')
                                            ->orderBy('irv_pk_id', 'desc')
                                            ->get()->toArray();
    }

    public function crearInstrumento(Request $request) {
        $id = null;
        $nuevaVersion = null;

        DB::connection($this->cliente)->transaction(function() use($request, &$id, &$nuevaVersion) {
            $nuevaVersion = DB::connection($this->cliente)->select(
                'select nextval(\'"'.$this->cliente.'".seq_rias_pym_vejez_mujeres\')'
            )[0]->nextval;

            $usuario = Auth::user()->id;

            $id = InstrumentosRiasPyMVejezMujeres::on($this->cliente)->create([
                'irv_version' => $nuevaVersion,
                'irv_comentarios' => $request->irv_comentarios,
                'irv_instrumento' => json_encode($request->irv_instrumento),
                'irv_usu_creacion' => $usuario
            ])->irv_pk_id;

            HistoricoInsRiasPyMVejezMujeres::on($this->cliente)->create([
                'irv_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hrv_accion' => 'Creación de una nueva versión del instrumento'
            ]);
        });

        return [$id, $nuevaVersion];
    }

    public function actualizarInstrumento(Request $request, $id) {
        DB::connection($this->cliente)->transaction(function() use($request, &$id) {
            $usuario = Auth::user()->id;

            InstrumentosRiasPyMVejezMujeres::on($this->cliente)->where('irv_pk_id', $id)->update([
                'irv_comentarios' => $request->irv_comentarios,
                'irv_instrumento' => $request->irv_instrumento
            ]);

            HistoricoInsRiasPyMVejezMujeres::on($this->cliente)->create([
                'irv_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hrv_accion' => 'Actualización del instrumento'
            ]);
        });
    }

    public function activarInstrumento(Request $request, $id) {
        DB::connection($this->cliente)->transaction(function() use($request, &$id) {
            $usuario = Auth::user()->id;

            $idActivo = InstrumentosRiasPyMVejezMujeres::on($this->cliente)
                                                    ->where('irv_activa', true)
                                                    ->pluck('irv_pk_id')[0];

            // Inactivar el actual
            InstrumentosRiasPyMVejezMujeres::on($this->cliente)->where('irv_pk_id', $idActivo)->update([
                'irv_activa' => false
            ]);

            HistoricoInsRiasPyMVejezMujeres::on($this->cliente)->create([
                'irv_fk_id' => $idActivo,
                'usu_fk_id' => $usuario,
                'hrv_accion' => 'El instrumento pasa a estado inactivo'
            ]);

            // Activar el nuevo instrumento
            InstrumentosRiasPyMVejezMujeres::on($this->cliente)->where('irv_pk_id', $id)->update([
                'irv_activa' => true
            ]);

            HistoricoInsRiasPyMVejezMujeres::on($this->cliente)->create([
                'irv_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hrv_accion' => 'El instrumento pasa a estado activo'
            ]);
        });
    }

    public function obtenerHistoricoVersion(Request $request, $id) {
        return HistoricoInsRiasPyMVejezMujeres::on($this->cliente)
                                   ->selectRaw('historico_ins_rias_pym_vejez_mujeres.*, users.name')
                                   ->join('base.users', 'id', 'usu_fk_id')
                                   ->where('irv_fk_id', $id)
                                   ->orderBy('created_at', 'desc')
                                   ->get()->toArray();
    }
}
