<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;

use App\Models\clientes\ParametrosVerifica;

use App\Http\Services\DBClientConnection;

class MiEntidadController extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    public function obtenerIdentificadorLogoEntidad(Request $request) {
        return [ParametrosVerifica::on($this->cliente)->first()->pav_logo_entidad];
    }

    public function obtenerLogoEntidad(Request $request) {
        $nombreLogo = ParametrosVerifica::on($this->cliente)->first()->pav_logo_entidad;

        if ($nombreLogo !== null) {
            $imagePath = public_path("storage/logos/entidades/".$nombreLogo.".png");
        } else {
            $imagePath = public_path("storage/logos/entidades/logo-tguia-generico.png");
        }

        $headers = ['Content-Type' => 'image/png'];

        return response()->file($imagePath, $headers);
    }

    public function actualizarLogoEntidad(Request $request) {
        $idLogo = null;

        DB::transaction(function() use($request, &$idLogo) {
            $idLogo = ParametrosVerifica::on($this->cliente)->first()->pav_logo_entidad;
            $file = file_get_contents($request->logo->path());

            if ($idLogo === null) {
                $idLogo = $this->cliente.Str::random(70);
            }

            Storage::put('public/logos/entidades/'.$idLogo.'.png', $file);
            ParametrosVerifica::on($this->cliente)->update(['pav_logo_entidad' => $idLogo]);
        });

        return [$idLogo];
    }
}
