<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Crypt;

class DecryptToken
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if ($request->header('Authorization')) {
            $authorizationHeader = $request->header('Authorization');
            $tokenDesencriptado = Crypt::decryptString($authorizationHeader);

            $request->headers->set('Authorization', 'Bearer '.$tokenDesencriptado);
        }

        return $next($request);
    }
}
