<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

use App\Http\Services\DBClientConnection;

use App\Http\Controllers\API\IndicadoresAuditoriaPamecController;

class IndicadoresPamecJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $cliente;
    private $ano;
    private $mes;

    public function __construct($ano, $mes)
    {
        $this->cliente = null;

        if (Auth::user() !== null) {
            $this->cliente = Auth::user()->cli_fk_id;
            $connection = new DBClientConnection();
            config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
        }

        $this->ano = $ano;
        $this->mes = $mes;
    }

    public function handle(): void
    {
        if ($this->cliente !== null) {
            $indicadoresPamec = new IndicadoresAuditoriaPamecController();
            $indicadoresPamec->establecerCliente($this->cliente);

            $request = new Request();
            $request->merge(['ano' => $this->ano, 'mes' => $this->mes,]);
            $indicadoresPamec->actualizarIndicadores($request);
        }
    }
}
