<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reps_prestadores_sedes', function (Blueprint $table) {
            $table->string('rps_pk_id', 50);
            $table->string('rpr_fk_id', 50);
            $table->integer('dep_fk_id');
            $table->integer('mun_fk_id');
            $table->string('rps_nombre_sede', 1000);
            $table->string('rps_correo', 1000)->nullable();
            $table->string('rps_direccion', 1000)->nullable();
            $table->string('rps_telefono', 1000)->nullable();
            $table->boolean('rps_sede_principal')->nullable();
            $table->string('rps_no_sede_principal', 10)->nullable();
            $table->boolean('rps_activo')->default(true);

            $table->primary('rps_pk_id');

            $table->foreign('rpr_fk_id')->references('rpr_pk_id')->on('reps_prestadores');
            $table->foreign('dep_fk_id')->references('dep_pk_id')->on('departamentos');
            $table->foreign('mun_fk_id')->references('mun_pk_id')->on('municipios');

            $table->index(['dep_fk_id', 'mun_fk_id']);
            $table->index(['rpr_fk_id', 'dep_fk_id', 'mun_fk_id']);
            $table->index('mun_fk_id');
            $table->index('rpr_fk_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reps_prestadores_sedes');
    }
};
